(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9196,        264]*)
(*NotebookOutlinePosition[      9896,        288]*)
(*  CellTagsIndexPosition[      9852,        284]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejercicio 1", "Exercise"],

Cell["\<\
Define un comando con la sintaxis \"cuentaelementos[lista]\" que al aplicarlo \
a una lista L proporcione como salida otra lista cuyos elementos son pares de \
la forma {a,na} donde a recorre todos los elementos distintos que aparecen en \
la lista L y na es el n\[UAcute]mero de veces que el elemento a figura en L. \
El siguiente ejemplo aclara esto.\
\>", "ExerciseText"],

Cell[CellGroupData[{

Cell[BoxData[
    \(L = Table[Random[Integer, {0, 10}], {100}]\)], "Input"],

Cell[BoxData[
    \({9, 7, 6, 7, 8, 10, 9, 10, 9, 3, 5, 5, 7, 1, 3, 6, 4, 5, 7, 6, 2, 0, 4, 
      3, 6, 3, 10, 5, 2, 10, 5, 10, 4, 3, 5, 7, 7, 6, 6, 9, 0, 7, 5, 3, 2, 
      10, 1, 2, 5, 1, 6, 6, 6, 2, 8, 1, 7, 7, 6, 0, 9, 8, 1, 8, 10, 4, 7, 2, 
      4, 4, 0, 5, 5, 2, 10, 4, 1, 2, 7, 4, 4, 0, 4, 6, 1, 7, 0, 9, 5, 7, 1, 
      2, 2, 3, 1, 4, 1, 10, 3, 9}\)], "Output"]
}, Open  ]],

Cell["\<\
El comando \"cuentaelementos[L]\" debe proporcionar la siguiente salida.\
\>", "ExerciseText"],

Cell[BoxData[
    \({{0, 6}, {1, 10}, {2, 10}, {3, 8}, {4, 11}, {5, 11}, {6, 11}, {7, 
        13}, {8, 4}, {9, 7}, {10, 9}}\)], "Output"],

Cell["\<\
El comando \"cuentaelementos[ ]\" debe poder trabajar con cualquier tipo de \
listas aunque no sean num\[EAcute]ricas. Aqu\[IAcute] tienes un comando que \
elige aleatoriamente una letra entre las 24 letras del alfabeto de forma \
equiprobable.\
\>", "ExerciseText"],

Cell[BoxData[{
    \(\(Clear[L];\)\), "\[IndentingNewLine]", 
    \(\(\(elige[k_]\)[x_] := 
        k/24 \[LessEqual] x < \((k + 1)\)/24;\)\), "\[IndentingNewLine]", 
    \(\(\[Lambda] = {a, b, c, d, e, f, g, h, i, j, k, m, n, o, p, q, r, s, t, 
          u, v, x, y, z, w};\)\), "\[IndentingNewLine]", 
    \(alealetra := 
      Module[{\[Beta]}, \[Beta] = Random[]; 
        Apply[Which, 
          Flatten[Table[{\(elige[\[Alpha]]\)[\[Beta]], \[Lambda][\([\[Alpha] \
+ 1]\)]}, {\[Alpha], 0, 23}]]]]\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(L = Table[alealetra, {100}]\)], "Input"],

Cell[BoxData[
    \({c, g, n, u, j, m, e, g, r, k, q, j, s, t, y, c, n, v, d, j, q, h, n, 
      o, n, a, a, t, d, n, v, m, k, c, f, c, r, h, g, z, e, m, c, o, n, e, o, 
      a, z, d, n, g, v, p, r, t, k, n, k, r, s, e, d, r, o, r, b, c, a, n, m, 
      b, a, j, y, u, e, t, g, a, s, g, u, i, a, c, q, r, m, j, p, o, k, v, c, 
      m, j, m, e, r}\)], "Output"]
}, Open  ]],

Cell["\<\
El comando \"cuentaelementos[L]\" debe proporcionar la siguiente salida.\
\>", "ExerciseText"],

Cell[BoxData[
    \({{a, 7}, {b, 2}, {c, 8}, {d, 4}, {e, 6}, {f, 1}, {g, 6}, {h, 2}, {i, 
        1}, {j, 6}, {k, 5}, {m, 7}, {n, 9}, {o, 5}, {p, 2}, {q, 3}, {r, 
        8}, {s, 3}, {t, 4}, {u, 3}, {v, 4}, {y, 2}, {z, 2}}\)], "Output"],

Cell["\<\
Comprueba tu comando con las listas que se generan al ejecutar la siguiente \
celda.\
\>", "ExerciseText"],

Cell[BoxData[
    RowBox[{\(lista1 = Table[Random[Integer, {0, 255}], {10000}]\), ";", 
      RowBox[{"(*", " ", 
        StyleBox[\(\[DownExclamation]no\ quites\ los\ ; ! \),
          FontColor->RGBColor[1, 0, 0]], " ", "*)"}], 
      "\[IndentingNewLine]", \(lista2 = Table[alealetra, {10000}]\), 
      ";"}]], "Input"],

Cell["\<\
Sugerencia: los comandos Sort[ ] y Count[ ] pueden ser \[UAcute]tiles.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "El comando NestList[f,z,n] da como salida una lista de n+1 elementos que \
son las iteradas sucesivas de \"f\" sobre z, empezando en el valor inicial  z \
y terminando en ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(f\^\([n]\)\),
            FontSlant->"Italic"], "(", 
          StyleBox["z",
            FontSlant->"Italic"], 
          StyleBox[")",
            FontSlant->"Italic"]}], TraditionalForm]]],
  " (el resultado de aplicar ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " n veces al valor ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  "). "
}], "ExerciseText"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[f, a, 3]\)], "Input"],

Cell[BoxData[
    \({a, f[a], f[f[a]], f[f[f[a]]]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Este comando puede actuar sobre listas de elementos. El comando \
NestList[f,lista,n] da como salida una lista de n+1 elementos que son las \
iteradas sucesivas de \"f\" sobre \"lista\", empezando en el valor inicial  \
\"lista\" y terminando en ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\^\([n]\)\)(lista)\)]],
  " (el resultado de aplicar ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " n veces a \"lista\"). "
}], "ExerciseText"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[f, {a, b, c}, 3]\)], "Input"],

Cell[BoxData[
    \({{a, b, c}, f[{a, b, c}], f[f[{a, b, c}]], 
      f[f[f[{a, b, c}]]]}\)], "Output"]
}, Open  ]],

Cell["\<\
Pero nosotros queremos que la funci\[OAcute]n \"f\" act\[UAcute]e sobre cada \
elemento de la lista. Para ello hacemos lo siguiente.\
\>", "ExerciseText"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(maplista[f_]\)[lista_] := 
        Map[f, lista];\)\), "\[IndentingNewLine]", 
    \(NestList[maplista[f], {a, b, c}, 3]\)}], "Input"],

Cell[BoxData[
    \({{a, b, c}, {f[a], f[b], f[c]}, {f[f[a]], f[f[b]], 
        f[f[c]]}, {f[f[f[a]]], f[f[f[b]]], f[f[f[c]]]}}\)], "Output"]
}, Open  ]],

Cell["\<\
Es decir, el comando NestList[maplista[f],Lista,n] proporciona como salida \
n+1 listas formadas cada una de ellas por las iteradas sucesivas de \"f\" \
sobre cada elemento de la lista inicial \"L\". Definamos una funci\[OAcute]n \
como sigue.\
\>", "ExerciseText"],

Cell[BoxData[{
    \(Clear[f]\), "\[IndentingNewLine]", 
    \(\(f[a_]\)[x_] := a*x*\((1 - x)\)\)}], "Input"],

Cell[TextData[{
  "Ahora viene tu trabajo.\na) Define un comando de la forma \
\"iteraciones[a_Real,L_List,n_Integer,m_Integer]\" que calcule n+1 listas \
formadas cada una de ellas por las iteradas sucesivas de \"f[a]\" sobre cada \
elemento de la lista inicial \"L\" y que devuelva solamente las m \
\[UAcute]ltimas listas. Calcula Transpose[iteraciones[3.4, \
Range[0.0,1.0,1.0/20],200,5]] e interpreta el resultado.\nb) Define un \
comando \"listafinal[a_Real,L_List,n_Integer,m_Integer]\" que aplicado a la \
lista \"iteraciones[a_Real,L_List,n_Integer,m_Integer]\" la convierta en otra \
lista cuyos elementos deben ser de la forma {",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(x, f\^\([k]\)\),
              "TraditionalForm"], "[", "a", "]"}], "[", "x", "]"}], 
        TraditionalForm]]],
  "} donde ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " recorre todos los elementos de la lista original L y ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\^\([k]\)\)[a]\)]],
  "[x] es la iterada k-\[EAcute]sima de la funci\[OAcute]n f[a] sobre el \
elemento x (k=n-m+1,n-m+2,...,n). Usa el comando Union[ ] para eliminar \
posibles elementos repetidos en dicha lista final. \nc) Sea \
L=Range[0.0,1.0,1.0/200]. Representa con ListPlot[lista, \
PlotStyle\[Rule]{PointSize[0.01],Hue[0]}, PlotRange\[Rule]All] cada una de \
las listas listafinal[3.4,L,100,100], listafinal[3.5,L,100,100], \
listafinal[3.7,L,100,100] e interpreta los resultados obtenidos en \
t\[EAcute]rminos de la convergencia de la sucesi\[OAcute]n de iteradas de \
f[a] sobre los distintos valores de x en el intervalo [0,1]."
}], "ExerciseText"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 31, 0, 68, "Exercise"],
Cell[1810, 55, 384, 6, 93, "ExerciseText"],

Cell[CellGroupData[{
Cell[2219, 65, 75, 1, 72, "Input"],
Cell[2297, 68, 371, 5, 168, "Output"]
}, Open  ]],
Cell[2683, 76, 104, 2, 41, "ExerciseText"],
Cell[2790, 80, 138, 2, 118, "Output"],
Cell[2931, 84, 276, 5, 67, "ExerciseText"],
Cell[3210, 91, 515, 10, 198, "Input"],

Cell[CellGroupData[{
Cell[3750, 105, 60, 1, 94, "Input"],
Cell[3813, 108, 362, 5, 168, "Output"]
}, Open  ]],
Cell[4190, 116, 104, 2, 41, "ExerciseText"],
Cell[4297, 120, 236, 3, 143, "Output"],
Cell[4536, 125, 116, 3, 41, "ExerciseText"],
Cell[4655, 130, 323, 6, 98, "Input"],
Cell[4981, 138, 102, 2, 41, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5120, 145, 31, 0, 68, "Exercise"],
Cell[5154, 147, 634, 20, 67, "ExerciseText"],

Cell[CellGroupData[{
Cell[5813, 171, 50, 1, 94, "Input"],
Cell[5866, 174, 64, 1, 93, "Output"]
}, Open  ]],
Cell[5945, 178, 463, 11, 93, "ExerciseText"],

Cell[CellGroupData[{
Cell[6433, 193, 58, 1, 94, "Input"],
Cell[6494, 196, 103, 2, 93, "Output"]
}, Open  ]],
Cell[6612, 201, 164, 3, 41, "ExerciseText"],

Cell[CellGroupData[{
Cell[6801, 208, 159, 3, 120, "Input"],
Cell[6963, 213, 141, 2, 118, "Output"]
}, Open  ]],
Cell[7119, 218, 275, 5, 67, "ExerciseText"],
Cell[7397, 225, 109, 2, 98, "Input"],
Cell[7509, 229, 1671, 32, 377, "ExerciseText"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

